//=============================================================================
// EDG.
//=============================================================================
class ExplosiveDiarrhiaGrenade extends ThrownProjectile;

#exec TEXTURE IMPORT NAME="GreenPoop" FILE="C:\DeusEx\MarkistanCity\Textures\GreenPoop.bmp" GROUP=Skins

var float	mpBlastRadius;
var float	mpProxRadius;
var float	mpLAMDamage;
var float	mpFuselength;

function TakeDamage(int Damage, Pawn EventInstigator, Vector HitLocation, Vector Momentum, name DamageType)
{
 Explode(Location, Normal(Velocity));

 Super.TakeDamage(Damage, EventInstigator, HitLocation, Momentum, DamageType);
}

function SpawnTearGas()
{
	local Vector loc;
	local BioPoison gas;
	local int i;
        local Turd2 Turd;

	if ( Role < ROLE_Authority )
		return;

	for (i=0; i<blastRadius/24; i++)
	{
		if (FRand() < 0.9)
		{
			loc = Location;
			loc.X += FRand() * blastRadius - blastRadius * 0.5;
			loc.Y += FRand() * blastRadius - blastRadius * 0.5;
			loc.Z += 32;
			gas = spawn(class'BioPoison', None,, loc);
			if (gas != None)
			{
				gas.Velocity = vect(0,0,0);
				gas.Acceleration = vect(0,0,0);
				gas.DrawScale = FRand() * 0.5 + 2.0;
				gas.LifeSpan = FRand() * 10 + 30;
                                gas.damage = 35;
				if ( Level.NetMode != NM_Standalone )
					gas.bFloating = False;
				else
					gas.bFloating = True;
				gas.Instigator = Instigator;
			}
		}
	}
        Turd = Spawn(class'Turd2', none,, location);
        Turd.Velocity = vect(0,0,0);
        Turd.DrawScale = FRand() * 0.5 + 2.0;
	Turd.LifeSpan = FRand() * 20 + 30; //make the turd last extra long, just 4 lulz.
	Turd.SetTimer(Turd.LifeSpan - 0.1, False);
        Turd.Instigator = Instigator;
}


function PlayBeepSound( float Range, float Pitch, float volume )
{
	if ( Level.NetMode != NM_Standalone )
		PlaySound( sound'Fart',SLOT_None, volume,, Range, Pitch );
	else
		PlaySound( sound'Fart',SLOT_None,,, Range, Pitch );
}

simulated function PreBeginPlay()
{
	Super.PreBeginPlay();

	if ( Level.NetMode != NM_Standalone )
	{
		blastRadius=mpBlastRadius;
		proxRadius=mpProxRadius;
		Damage=mpLAMDamage;
		fuseLength=mpFuselength;
		bIgnoresNanoDefense=True;
	}
}

defaultproperties
{
     mpBlastRadius=512.000000
     mpProxRadius=128.000000
     mpLAMDamage=25.000000
     mpFuselength=1.500000
     fuseLength=3.000000
     proxRadius=160.000000
     DamageType=TearGas
     spawnWeaponClass=Class'MarkistanCity.WeaponEDG'
     ItemName="Explosive Diarrhia Grenade (EDG)"
     speed=1000.000000
     MaxSpeed=1000.000000
     Damage=20.000000
     MomentumTransfer=50000
     ImpactSound=Sound'DeusExSounds.Weapons.GasGrenadeExplode'
     ExplosionDecal=Class'DeusEx.ScorchMark'
     LifeSpan=0.000000
     Mesh=LodMesh'DeusExItems.GasGrenadePickup'
     CollisionRadius=4.300000
     CollisionHeight=3.800000
     Mass=5.000000
     Buoyancy=2.000000
     Skin=Texture'EDG3rdTex1'
}
